//
//  GSShortcutCommandProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 08.01.19.
//  Copyright © 2019 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSGlyphViewControllerProtocol.h>

NS_ASSUME_NONNULL_BEGIN

@protocol GSShortcutCommandProtocol <NSObject>
/** This is called right before the shortcut action is performed

 @param action The action to be called
 @param editViewController the currently active tab

 @return Return YES if you liked to be called at that point. Or NO if you don’t
 */
- (BOOL)validateShortcutCommand:(SEL)action editViewController:(NSViewController<GSGlyphEditViewControllerProtocol> *)editViewController;

@end

NS_ASSUME_NONNULL_END
